import { z } from 'zod';

export const registerSchema = z.object({
  email: z.string().email('Email invalid'),
  password: z.string().min(6, 'Parola trebuie să aibă minim 6 caractere'),
  restaurantName: z.string().min(3, 'Numele restaurantului trebuie să aibă minim 3 caractere'),
});

export const categorySchema = z.object({
  nameRo: z.string().min(1, 'Numele în română este obligatoriu'),
  nameEn: z.string().optional(),
  icon: z.string().optional(),
});

export const productSchema = z.object({
  categoryId: z.string().uuid('ID categorie invalid'),
  nameRo: z.string().min(1, 'Numele în română este obligatoriu'),
  nameEn: z.string().optional(),
  descriptionRo: z.string().optional(),
  descriptionEn: z.string().optional(),
  price: z.number().positive('Prețul trebuie să fie pozitiv'),
  imageUrl: z.string().optional(),
  allergens: z.array(z.string()).optional(),
  isVisible: z.boolean().optional(),
});