# Digital Menu SaaS

Platformă SaaS pentru meniuri digitale restaurante cu abonamente Stripe și AI.

## Setup Local

### Prerequisite

- Node.js 18+
- MySQL 8.0+
- Stripe Account (test mode)
- OpenAI API Key

### Instalare
```bash
# 1. Instalare dependențe
npm install

# 2. Configurare .env.local
cp .env.example .env.local
# Editează .env.local cu datele tale

# 3. Setup Database
npm run db:push

# 4. Seed Plans
npm run db:seed:plans

# 5. Seed Demo Data
npm run db:seed

# 6. Rulare development
npm run dev

# 7. (Terminal separat) Stripe webhook listener
npm run stripe:listen
```

### Acces Aplicație

- **Dashboard**: http://localhost:3000/login
- **Demo credentials**: demo@restaurant.ro / demo123
- **Admin credentials**: admin@vestho.com / admin123
- **Public menu**: http://localhost:3000/r/la-mare

## Planuri Disponibile

### Trial
- 7 zile gratuit
- Max 5 produse
- Max 3 categorii
- 1 limbă (RO)
- Fără credite AI

### Basic (€9.99/lună sau €99.99/an)
- Max 50 produse
- Max 10 categorii
- 1 limbă (RO)
- 20 credite AI/lună

### Pro (€24.99/lună sau €249.99/an)
- Max 300 produse
- Max 50 categorii
- 3 limbi (RO + EN + altele)
- 100 credite AI/lună
- Custom domain

### Enterprise
- Produse nelimitate
- Categorii nelimitate
- 10 limbi
- 500 credite AI/lună
- Custom pricing

## Structura Proiect
```
digital-menu-saas/
├── prisma/              # Database schema & seeds
├── src/
│   ├── app/            # Next.js App Router
│   ├── components/     # React components
│   ├── lib/            # Utilities & business logic
│   └── types/          # TypeScript types
├── public/             # Static assets
└── ...config files
```

## Scripturi Disponibile
```bash
npm run dev          # Development server
npm run build        # Production build
npm run start        # Production server
npm run db:push      # Push schema to DB
npm run db:seed:plans # Seed plans
npm run db:seed      # Seed demo data
npm run db:studio    # Prisma Studio
npm run stripe:listen # Stripe webhook listener
```

## Environment Variables

Verifică `.env.example` pentru toate variabilele necesare.

## Deployment

### Vercel

1. Push la GitHub
2. Import în Vercel
3. Configurare environment variables
4. Deploy

### Database

Folosește un provider MySQL:
- PlanetScale
- Railway
- AWS RDS
- sau altul

## Support

Pentru probleme: contact@vestho.com
```

**STATUS:** ✅ FINAL

---

# FIȘIER 50: public/uploads/.gitkeep

**CALE:** `public/uploads/.gitkeep`
```
# Acest folder păstrează imaginile uploadate